/// ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
/// ' Microsoft Content Management Server - Sample Code 
/// '
/// ' This sample code is provided "AS IS" with no warranties, and confers no rights. 
/// ' You assume all risk for your use.  2002 Microsoft Corporation. All rights reserved.
/// '
/// ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

using System;
using System.Web;
using System.Web.UI;
using System.ComponentModel;
//Add reference for toolbox customization
using System.Drawing;
//Array reference for array of CMS objects
using System.Collections;
//Add reference for treeview control
using Microsoft.Web.UI.WebControls;
//Add reference to the CMS API
using Microsoft.ContentManagement.Publishing;
//Add reference for Tracing
using System.Diagnostics;

namespace McmsSpsWebControlLibrary
{
	/// <summary>
	/// 
	/// 
	/// The Mcms navigation control. This class implements the left navigation control. 
	/// </summary>
	/// 
	[Designer(typeof(McmsSpsWebControlLibrary.Design.McmsNavigationDesigner)),
	ToolboxBitmapAttribute(typeof(McmsNavigationControl), "MCMSToolBoxImage.bmp"),
	ToolboxData("<{0}:McmsNavigationControl runat=server></{0}:McmsNavigationControl>")]
	public class McmsNavigationControl : Microsoft.Web.UI.WebControls.TreeView
	{
		#region Public constructors
		public McmsNavigationControl(): base()
		{
			startChannel = "Channels";
			linkTarget = "_self";

			string SeparatorString = " :: ";
			ChannelStyle = "color : #cc6633;text-decoration : none; font-weight:bold;";
			PostingStyle = "margin-center : 1em;color : #cc6633;text-decoration : none;margin-left : 0px;";
//			ChannelStyle = "color : #336633;text-decoration : none; font-weight:bold;";
//			PostingStyle = "margin-center : 1em;color : #336633;text-decoration : none;margin-left : 0px;";
			// Write a line to the Listener
			System.Diagnostics.Trace.WriteLine(System.DateTime.Now + SeparatorString + "Control" + SeparatorString + "Left Navigation Control" + SeparatorString + "This is the constructor for the Left Navigation Control.");
			// Record your output
			System.Diagnostics.Trace.Flush();
	
		}
		#endregion Public constructors

		#region Private member variables
			private string text;
			//User defined properties 
			private string designText;
			private string cssClass;
			private string hidePageName;
			private string startChannel;
			private string linkTarget;
			private Channel CurrentStartChannel=null;

			//Style properties for Channels and Postings;
			private string ChannelStyle;
			private string PostingStyle;
			
			//Select list for name format
			public enum enumNameOptions{Name, DisplayName};
			private enumNameOptions enumNameOption;			
		#endregion Private member variables

		#region Properties
		/// <summary>
		///		Default text property.
		/// </summary>
		/// 
		[Bindable(true), 
			Category("Appearance"), 
			DefaultValue("Left Navigation Control")] 
		public string Text 
		{
			get
			{
				return text;
			}

			set
			{
				text = value;
			}
		}
		
		/// <summary>
		///		Start Channel property.
		/// </summary>
		/// 
		[Browsable(true), 
		Description("Start Channel"),
		Category("Navigation"),
		DefaultValue("Channels")]
		public string StartChannel 
		{
			get { return startChannel; }
			set { startChannel = value; }
		}

		//Allow user to change the value of property - in design view
		bool ShouldSerializeStartChannel(){return true;}

		/// <summary>
		///		Link Target property.
		/// </summary>
		/// 
		[Browsable(true), 
		Description("Link Target"),
		Category("Navigation"),
		DefaultValue("_self")]
		public string LinkTarget 
		{
			get { return linkTarget; }
			set { linkTarget = value; }
		}

		//Allow user to change the value of property - in design view
		bool ShouldSerializeLinkTarget(){return true;}

		/// <summary>
		///		The name option used in the control.
		///		Options: DisplayName, Name
		/// </summary>
		/// 		
		[Description("The Channel name type used in the breadcrumb. Options are 'DisplayName' and 'Name'."),
		Category("LeftNavigation"),]
		public enumNameOptions NameOptions
		{
			get { return enumNameOption; }
			set { enumNameOption = value; }
		}			
		//Allow user to change the value of property - in design view
		bool ShouldSerializeNameOpions(){return true;}

		/// <summary>
		///		The text that appears in the control in design view.
		/// </summary>
		/// 
		[Browsable(true), 
		Description("Text that appears in design view."),
		Category("Navigation"),
		DefaultValue("LeftNavigation")]
		public string DesignText
		{
			get { return designText; }
			set { designText = value; }
		}
		//Allow user to change the value of property - in design view
		bool ShouldSerializeDesignText(){return true;}
		
		/// <summary>
		///		The CSS style class for the control - both runtime and design.
		/// </summary>
		/// 
		[Browsable(true), 
		Description("Default CSS Style for the control."),
		Category("Appearance")]
		public override string CssClass
		{
			get { return cssClass; }
			set { cssClass = value; }
		}
		//Allow user to change the value of property - in design view
		bool ShouldSerializeCssClass(){return true;}

		/// <summary>
		///		Option to hide a certain page (by name).
		/// </summary>
		/// 		
		[Description("Optional hidden page name."),
		Category("LeftNavigation"),]
		public string HiddenPage
		{
			get { return hidePageName; }
			set { hidePageName = value; }
		}	
		//Allow user to change the value of property - in design view
		bool ShouldSerializeHiddenPage(){return true;}
		#endregion Properties

		#region Private functions

		#region Generic Tree Creation
		//This function creates child controls 
		protected override void CreateChildControls()
		{
			base.CreateChildControls();
			CmsHttpContext cmsContext=CmsHttpContext.Current;

			//Code for Tracing
			Page.Trace.Write("Navigation Control","Finding Parent Channel");
			

			ChannelCollection colRootChannels;
			colRootChannels=cmsContext.RootChannel.Channels;
			//If root channel is start channel
			if(StartChannel.ToLower()==cmsContext.RootChannel.Name.ToLower())
			{
				CurrentStartChannel=cmsContext.RootChannel;
			}
			else
			{
				//If the StartChannel property is not specified, find it by using the 
				//FindStartChannel function
				if (StartChannel.Trim() == "")
				{
					//Find the Start Channel
					FindStartChannel(cmsContext.RootChannel.Channels);
				}
				//If the StartChannel is specified, get the channel object using the 
				//GetByPath property
				else
				{
					CurrentStartChannel = cmsContext.Searches.GetByPath(StartChannel) as Channel;
				}

			}
			if(CurrentStartChannel==null)
			{
				CurrentStartChannel=cmsContext.RootChannel;
			}
		
			this.Nodes.Clear();
			
			//Declaring Nodes for Navigation Control
			TreeNodeType channelNode=new TreeNodeType();
			TreeNodeType postingNode=new TreeNodeType();

			this.TreeNodeTypes.Add(channelNode);
			this.TreeNodeTypes.Add(postingNode);

			TreeNode rootChannelNode=new TreeNode();
			rootChannelNode.ID="Root";
			rootChannelNode.Text=HttpUtility.HtmlEncode(CurrentStartChannel.Name);
			rootChannelNode.NavigateUrl=CurrentStartChannel.Url;
			rootChannelNode.Target = LinkTarget;
			rootChannelNode.DefaultStyle = CssCollection.FromString(ChannelStyle);
			rootChannelNode.SelectedStyle = CssCollection.FromString(ChannelStyle);
			//checking if current channel contains subchannels
			if(CurrentStartChannel.Channels!= null && CurrentStartChannel.Channels.Count>0)
			{
				//This funtion call will create a tree of nodes for all the channels below the Root channel
				CreateTree(CurrentStartChannel,rootChannelNode);
				
				//This function call will create a tree of nodes for all the postings under the Root channel
				CreatePostings(CurrentStartChannel,rootChannelNode);
			}
			rootChannelNode.Expandable=ExpandableValue.CheckOnce;
			//Add all Channel and Posting Nodes under the Tree Control
			foreach(TreeNode newChannelNode in rootChannelNode.Nodes)
				this.Nodes.Add((TreeNode)newChannelNode.Clone());
			//If you do not want to display the Root Channel on the Left Navigation,
			//remove it using this call.
			rootChannelNode.Remove();
			//Expand all the Channel in the Start Channel
            this.ExpandLevel=1;
			//Allow to expand and collapse the Tree by clicking on the Channel Link
			this.SelectExpands=true;
		}
		/// <summary>
		/// Recursive Function to create Channel Nodes under the Parent Node
		/// </summary>
		private void CreateTree(Channel currentChannel,TreeNode parentNode)
		{
			if(currentChannel.Channels!=null && currentChannel.Channels.Count>0)
			{
				//Find the Sub Channel under each Channel
				foreach(Channel subChannel in currentChannel.Channels)
				{
					TreeNode channelNode=new TreeNode();
					if(NameOptions.ToString()=="Name")
					{
						channelNode.Text=HttpUtility.HtmlEncode(subChannel.Name.Trim());
					}
					else
					{
						channelNode.Text=HttpUtility.HtmlEncode(subChannel.DisplayName.Trim());
					}
					channelNode.NavigateUrl=subChannel.Url;
					channelNode.Target=LinkTarget;
					channelNode.DefaultStyle = CssCollection.FromString(ChannelStyle);
					channelNode.SelectedStyle = CssCollection.FromString(ChannelStyle);
					//Add the Channel Node under its Parent Node
					parentNode.Nodes.Add(channelNode);
					//Expand the Channel Node if it is the Current CMSContext Channel
					if(CmsHttpContext.Current.Channel == subChannel)
						channelNode.Expanded=true;
					else
					{
						Channel parentChannel = CmsHttpContext.Current.Channel.Parent;
						bool isExpanded = false;
						while (parentChannel != CurrentStartChannel && parentChannel !=null)
						{
							if(parentChannel == subChannel)
							{
								isExpanded = true;
								break;
							}
							parentChannel = parentChannel.Parent;
						}
						if(isExpanded)
							channelNode.Expanded = true;
						else
							channelNode.Expanded = false;

					}
					channelNode.Expandable = ExpandableValue.Auto;
					//channelNode.Expanded is true for the selected channel.
					//For all the channels that are not selected, thier children channels and postings are not 
					//displayed. Loading these children in the tree view wastes times.
					//Hence, recursion is done only for the selected channel.
					if (channelNode.Expanded)
					{
						CreateTree(subChannel,channelNode);
						//Create Posting Node For Current Channel Node
						CreatePostings(subChannel,channelNode);
					}
				}
			}
		}
		/// <summary>
		/// Recursive Function to create Posting Nodes under the Channel Node
		/// </summary>
		private void CreatePostings(Channel currentChannel,TreeNode currentNode)
		{
			//CurrentChannel.DefaultPostingName="default";
			if(currentChannel.Postings!=null && currentChannel.Postings.Count>0)
			{
				//Find Posting under each Channel Node
				foreach(Posting subPosting in currentChannel.Postings)
				{	
					//If posting name is 'default' hide it
					if(subPosting.Name.Trim().ToLower()!="default")
					{
						TreeNode currentPosting=new TreeNode();
						if(NameOptions.ToString()=="Name")
						{
							currentPosting.Text=HttpUtility.HtmlEncode(subPosting.Name.Trim());
						}
						else
						{
							currentPosting.Text=HttpUtility.HtmlEncode(subPosting.DisplayName.Trim());
						}
						currentPosting.NavigateUrl=subPosting.Url;
						currentPosting.Target=LinkTarget;
						currentPosting.DefaultStyle = CssCollection.FromString(PostingStyle);
						currentPosting.SelectedStyle = CssCollection.FromString(PostingStyle);
						//Add the Posting Node under Current Channel Node
						currentNode.Nodes.Add(currentPosting);
					}
				}
			}
		}

		/// <summary>
		/// Function to Find the Start Channel 
		/// </summary>
		private void FindStartChannel(ChannelCollection colRootChannels)
		{
			
			if(colRootChannels.Count>0)
			{
				foreach(Channel hChannel in colRootChannels)			
				{		
					if ((hChannel.Name.ToLower() == StartChannel.ToLower()) || (hChannel.DisplayName.ToLower() == StartChannel.ToLower()))
					{
						//Exit From Recursive Loop when Start Channel is found
						CurrentStartChannel = hChannel;
						break;
					}
					if(hChannel.Channels.Count > 0)
					{
						FindStartChannel(hChannel.Channels);
					}
				}
		
			}
		}
	#endregion
		#endregion Private functions
	} //Close Class

} //Close Namespace

//EOF - SC - Jan 2002
